<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Wallet
Description: Default module to apply changes to the Wallet
Version: 2.3.0
Requires at least: 2.3.*
*/

define('WALLET', 'wallet');
define('WALLET_ATTACHMENTS_FOLDER', FCPATH . 'uploads/wallet' . '/');

$CI = &get_instance();

hooks()->add_action('admin_init', 'wallet_init_menu_items');
hooks()->add_action('before_payment_recorded', 'payment_calculations');
hooks()->add_action('customers_navigation_end', 'client_wallet_init_menu_items');
hooks()->add_action('after_invoice_added', 'new_invoice_payment');

function client_wallet_init_menu_items()
{
    if (is_client_logged_in()) {
        echo '<li class="customers-nav-item-wallet"><a href="' . site_url('wallet') . '">' . _l('wallet') . '</a></li>';
    }
}

/**
 * Load the module helper
 */
// $CI->load->helper(CLIENT_TASKS_MODULE_NAME . '/client_tasks');
$CI->load->helper(WALLET . '/wallet');

/**
 * Register activation module hook
 */
register_activation_hook(WALLET, 'wallet_activation_hook');

function wallet_activation_hook()
{
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(WALLET, [WALLET]);

/**
 * wailet module menu items in setup in admin_init hook
 * @return null
 */
function wallet_init_menu_items()
{
    $CI = &get_instance();
    $CI->app_menu->add_sidebar_menu_item('wallet', [
        'slug'     => 'wallet',
        'name'     => _l('wallet'),
        'position' => 5,
        'icon'     => 'fa fa-money',
    ]);
    $CI->app_menu->add_sidebar_children_item('wallet', [
        'slug'     => 'transection',
        'name'     => _l('transection'),
        'href'     => admin_url('wallet/transection'),
        'position' => 5,
        'badge'    => []
    ]);
}

function payment_calculations($data)
{
    $CI = &get_instance();
    if ($data['wallet'] == 1) {
        // $data['amount'] = $data['amount'];
        // $data['amount'] = 100;
        $extra_amount  = '';
        $invoiceid = $data['invoiceid'];

        $CI->db->where('id', $invoiceid);
        $invoice = $CI->db->get(db_prefix() . 'invoices')->row();

        $amount = get_invoice_total_left_to_pay($invoiceid);
        $extra_amount  = $data['amount'] - $amount;

        $CI->db->where_not_in('id', $invoiceid);
        $CI->db->where_in('status', [1, 3, 4]);

        if ($data['admin'] != 1) {
            $CI->db->where('clientid', get_client_user_id());
        } else {
            $CI->db->where('clientid', $data['clientid']);
        }

        $invoices = $CI->db->get(db_prefix() . 'invoices')->result_array();
        unset($data['make_payment']);
        unset($data['hash']);
        unset($data['wallet']);
        unset($data['admin']);
        unset($data['clientid']);
        if ($extra_amount > 0) {

            foreach ($invoices as $inv) {
                $invoice_amount = get_invoice_total_left_to_pay($inv['id']);
                if ($extra_amount > 0) {
                    if ($extra_amount == $invoice_amount) {
                        $data['amount'] = $invoice_amount;
                        $extra_amount  = 0;
                    } else if ($extra_amount > $invoice_amount) {
                        $data['amount'] = $invoice_amount;
                        $extra_amount  = $extra_amount - $invoice_amount;
                    } else {
                        $data['amount'] = $extra_amount;
                        $extra_amount = 0;
                    }

                    $data['invoiceid'] = $inv['id'];
                    $CI->db->insert(db_prefix() . 'invoicepaymentrecords', $data);
                    $insert_id = $CI->db->insert_id();
                    $force_update = true;
                    update_invoice_status($data['invoiceid'], $force_update);
                } else {
                    $extra_amount  = 0;
                }
            }
        } else {
            $amount = $data['amount'];
            $extra_amount = 0;
        }
        $CI->db->where('userid', $invoice->clientid);
        $CI->db->update(db_prefix() . 'clients', [
            'wallet_amount' => $extra_amount,
        ]);
        $data['invoiceid'] = $invoiceid;
        $data['amount'] = $amount;
        return $data;
    } else {
        return $data;
    }
}
function new_invoice_payment($invoice_id)
{
    $CI = &get_instance();
    $CI->db->where('id', $invoice_id);
    $invoice = $CI->db->get(db_prefix() . 'invoices')->row();

    // get client's wallent amount
    $CI->db->where('userid', $invoice->clientid);
    $client = $CI->db->get(db_prefix() . 'clients')->row();

    $CI->load->model('payments_model');
    $data = [
        'invoiceid' =>  $invoice_id,
        'amount' => $client->wallet_amount,
        'date' => date('y-m-d'),
        'paymentmode' => 1,
        'wallet' => 1,
        'transactionid' => null,
        'note' => '',
        'daterecorded' => date('y-m-d'),
    ];

    if ($client->wallet_amount > 0) {
        $CI->payments_model->process_payment($data, $invoice_id);
    } else {

        return $invoice_id;
    }
}
