<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="clearfix mtop20"></div>
                        <?php
                        $table_data = array();
                        $_table_data = array(
                            array(
                                'name' => _l('number_sign'),
                                'th_attrs' => array('class' => 'toggleable', 'id' => 'th-number_sign')
                            ),
                            array(
                                'name' => _l('company'),
                                'th_attrs' => array('class' => 'toggleable', 'id' => 'th-clientid')
                            ),
                            array(
                                'name' => _l('status'),
                                'th_attrs' => array('class' => 'toggleable', 'id' => 'th-status')
                            ),

                            array(
                                'name' => _l('datecreated'),
                                'th_attrs' => array('class' => 'toggleable', 'id' => 'th-datecreated')
                            ),
                            array(
                                'name' => _l('dateupdate'),
                                'th_attrs' => array('class' => 'toggleable', 'id' => 'th-dateupdate')
                            ),
                            array(
                                'name' => _l('action'),
                                'th_attrs' => array('class' => 'toggleable', 'id' => 'th-action')
                            ),
                        );

                        foreach ($_table_data as $_t) {
                            array_push($table_data, $_t);
                        }
                        render_datatable($table_data, 'wallet_transections', [], [
                            'data-last-order-identifier' => 'customers',
                            'data-default-order'         => get_table_last_order('customers'),
                        ]);

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- /////////// Transection Modal -->
<div class="modal" id="transection_Modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Transection Amount</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <?php echo form_open('wallet/transection/transections/', array('id' => 'transection-payment_form', 'novalidate' => true)); ?>
                <?php echo form_hidden('clientid', '') ?>
                <?php echo form_hidden('transection_mode', '') ?>
                <?php echo form_hidden('transection_id', '') ?>
                <?php echo form_hidden('admin', '') ?>
                <?php echo render_input('amount', 'credit_amount') ?>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary transection-payment-submit">Submit</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(function() {
        var CustomersServerParams = {};
        $.each($('._hidden_inputs._filters input'), function() {
            CustomersServerParams[$(this).attr('name')] = '[name="' + $(this).attr('name') + '"]';
        });
        initDataTable('.table-wallet_transections', admin_url + 'wallet/transection/table', [0], [0], CustomersServerParams, <?php echo hooks()->apply_filters('customers_table_default_order', json_encode(array(0, 'asc'))); ?>);
    });

    function payment_transactions(clientid, transection_mode, transection_id) {

        $('#transection_Modal').modal('show');
        $('input[name="clientid"]').val(clientid);
        $('input[name="transection_mode"]').val(transection_mode);
        $('input[name="transection_id"]').val(transection_id);
        $('input[name="admin"]').val('1');
    }
</script>