<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Wallet_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('payment_modes_model');
        $this->load->model('payments_model');
    }
    public function add_payments($data)
    {
        if ($data['admin'] == 1) {
            $this->db->where('clientid', $data['clientid']);
        } else {
            $this->db->where('clientid', get_client_user_id());
        }

        $this->db->where_in('status', [1, 3, 4]);
        $invoices = $this->db->get(db_prefix() . 'invoices')->result_array();

        $this->db->where_in('status', [1, 3, 4]);
        if ($data['admin'] == 1) {
            $this->db->where('clientid', $data['clientid']);
        } else {
            $this->db->where('clientid', get_client_user_id());
        }

        $res = $this->db->get(db_prefix() . 'invoices')->row();
        $__invoice_id = $res ? $res->id : '';

        if ($data['admin'] != 1) {
            $_data = $this->input->post();
            $_data['invoiceid'] = $__invoice_id;
            $_data['wallet'] = 1;
        } else {
            $_data = [
                'paymentmode'   => $data['paymentmode'],
                'amount'    => $data['amount'],
                'invoiceid' => $__invoice_id,
                'clientid'    => $data['clientid'],
                'wallet'    => 1,
                'admin'    => 1,
            ];
        }

        if (!is_numeric($data['paymentmode']) || $data['admin'] == 1) {
            $success = $this->payments_model->process_payment($_data, $__invoice_id);
        }

        $status = (is_numeric($data['paymentmode'])) ? 0 : 1;

        if ($status == '0' && $data['admin'] != '1') {
            $transaction_data = [
                'clientid' => get_client_user_id(),
                'status' => 0,
                'mode' => $data['paymentmode'],
                'datecreated' => date('y-m-d'),
            ];

            $this->db->insert(db_prefix() . 'wallet_transections', $transaction_data);
            $insert_id = $this->db->insert_id();
            handle_wallet_attachments($insert_id, 'wallet');
            
        } else if ($success != '' && $status == '0') {

            $this->db->where('id', $data['transection_id'])->update(db_prefix() . 'wallet_transections', ['status' => 1, 'dateupdate' => date('y-m-d')]);
        }
        return true;
    }
}
