<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Wallets_admin extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('wallet_model');
    }

    /* Get all wallet in case user go on index page */
    public function index($id = '')
    {
        $this->list_wallets($id);
    }

    /* List all wallets datatables */
    public function list_wallets($id = '')
    {
        $data['title']                 = _l('wallet');

        $this->load->view('wallet/transection', $data);
    }

    public function table()
    {
        $this->app->get_table_data(module_views_path(WALLET, 'table'));
    }
    public function transections()
    {

        $tran_data = $this->input->post();
        $data = [];
        $data = [
            'paymentmode'     => $tran_data['transection_mode'],
            'amount'          => $tran_data['amount'],
            'clientid'        => $tran_data['clientid'],
            'admin'           => $tran_data['admin'],
            'transection_id'  => $tran_data['transection_id'],

        ];
        $success = $this->wallet_model->add_payments($data);

        if (!$success) {
            set_alert('warning', _l('invoice failed'));
            redirect(site_url('wallet/Wallets_admin'));
        } else {
            set_alert('success', _l('invoice paid successfully'));
            redirect(site_url('wallet/Wallets_admin'));
        }
    }
}
