<?php

defined('BASEPATH') or exit('No direct script access allowed');

use app\services\ValidatesContact;

class Wallet extends ClientsController
{
    use ValidatesContact;
    public function __construct()
    {

        parent::__construct();
        hooks()->do_action('', $this);
        $this->load->model('payment_modes_model');
        $this->load->model('payments_model');
        $this->load->model('wallet_model');
    }
    public function index()
    {
        $this->db->where('userid', get_client_user_id());
        $client = $this->db->get(db_prefix() . 'clients')->row();

        $data['payment_modes'] = $this->payment_modes_model->get('', ['active' => 1]);
        $data['client'] = $client;

        $this->db->where_in('status', [1, 3, 4]);
        $this->db->where('clientid', get_client_user_id());
        $invoices = $this->db->get(db_prefix() . 'invoices')->result_array();

        $total = 0;

        foreach ($invoices as $invoice) {

            $total += get_invoice_total_left_to_pay($invoice['id']);
        }
        $data['total'] = $total;
        $this->data($data);
        $this->view('wallet/wallet');
        $this->layout();
    }
    public function wallets()
    {
        $data = $this->input->post();
        // echo"<pre>";print_r($data);exit;
        if (!$data['paymentmode']) {
            set_alert('warning', _l('invoice_html_payment_modes_not_selected'));
            redirect(site_url('wallet'));
        } elseif ((!$data['amount'] || $data['amount']  == 0) && get_option('allow_payment_amount_to_be_modified') == 1) {
            set_alert('warning', _l('invoice_html_amount_blank'));
            redirect(site_url('wallet'));
        }

        $status = (is_numeric($data['paymentmode'])) ? 0 : 1;
        $success = $this->wallet_model->add_payments($data);

        if ($success != '' && $status == '1') {
            set_alert('success', _l('invoice_paid_successfully'));
            redirect(site_url('wallet/wallet'));
        } elseif ($this->input->is_ajax_request()) {
            set_alert('success', _l('transection_added_successfully'));
            echo json_encode(['success' => 1]);
            exit;
        } else {
            set_alert('warning', _l('transection_failed'));
            redirect(site_url('wallet/wallet'));
        }
    }
}
