<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="user-scalable=no, width=device-width, initial-scale=1, maximum-scale=1">
  <title><?php echo $form->name; ?></title>
  <?php app_external_form_header($form); ?>
  <?php hooks()->do_action('app_web_to_lead_form_head'); ?>
  <script src="<?php echo base_url('assets/plugins/phone_mask/jquery-3.3.1.min.js');?>"></script>
  <script src="<?php echo base_url('assets/plugins/phone_mask/intlTelInput.js');?>"></script>
  <script src="<?php echo base_url('assets/plugins/phone_mask/jquery.mask.js');?>"></script>
  <link href="<?php echo base_url('assets/plugins/phone_mask/intlTelInput.css');?>" rel="stylesheet" />
</head>
<body class="web-to-lead <?php echo $form->form_key . ($this->input->get('styled') === '1' ? ' styled' : ''); ?>"<?php if (is_rtl(true)) {
  echo ' dir="rtl"';
} ?>>
<style>
.iti--allow-dropdown{
  width:100% !important;
}
</style>
<?php 
    $IPaddress = getUserIP();
    $url       = "http://ipinfo.io/{$IPaddress}?token=e6f0419ec5377f";
    $ch = curl_init($url);
    
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
   $details = json_decode($response);
    
?>
<div class="container-fluid">
  <div class="row">
    <div class="<?php if($this->input->get('col')){echo $this->input->get('col');} else {echo $this->input->get('styled') === '1' ? 'col-md-6 col-md-offset-3' : 'col-md-12';} ?> form-col">
      <?php if($this->input->get('with_logo')) { ?>
        <div class="text-center mbot10 logo">
          <?php get_dark_company_logo(); ?>
        </div>
      <?php } ?>
      <div id="response"></div>
      <?php echo form_open_multipart($this->uri->uri_string(),array('id'=>$form->form_key,'class'=>'disable-on-submit')); ?>
      <?php hooks()->do_action('web_to_lead_form_start'); ?>
      <?php echo form_hidden('key',$form->form_key); ?>
      <div class="row">
        <?php foreach($form_fields as $field){
         render_form_builder_field($field);
       } ?>
       <?php if(show_recaptcha() && $form->recaptcha == 1){ ?>
         <div class="col-md-12">
           <div class="form-group"><div class="g-recaptcha" data-sitekey="<?php echo get_option('recaptcha_site_key'); ?>"></div>
           <div id="recaptcha_response_field" class="text-danger"></div>
         </div>
       <?php } ?>
       <?php if (is_gdpr() && get_option('gdpr_enable_terms_and_conditions_lead_form') == 1) { ?>
         <div class="col-md-12">
          <div class="checkbox chk">
            <input type="checkbox" name="accept_terms_and_conditions" required="true" id="accept_terms_and_conditions" <?php echo set_checkbox('accept_terms_and_conditions', 'on'); ?>>
            <label for="accept_terms_and_conditions">
              <?php echo _l('gdpr_terms_agree', terms_url()); ?>
            </label>
          </div>
        </div>
      <?php } ?>
      <input type="hidden" name="phonenumber" id="full_number"/>
      <input type="hidden" name="ip_address" value="<?php echo $IPaddress;?>">
      <!-- <input type="hidden" name="visitor_details" value="<?php echo $json;?>">
      <input type="hidden" name="time_zone" value="<?php echo $details->timezone;?>">
       -->
      <div class="clearfix"></div>
      <div class="text-left col-md-12 submit-btn-wrapper">
        <button class="btn btn-success" id="form_submit" type="submit"><?php echo $form->submit_btn_name; ?></button>
      </div>
    </div>

    <?php hooks()->do_action('web_to_lead_form_end'); ?>
    <?php echo form_close(); ?>
  </div>
</div>
</div>
<?php app_external_form_footer($form); ?>
<script>
 var form_id = '#<?php echo $form->form_key; ?>';
 $(function() {
   $(form_id).appFormValidator({

    onSubmit: function(form) {

     $("input[type=file]").each(function() {
      if($(this).val() === "") {
        $(this).prop('disabled', true);
      }
    });

     var formURL = $(form).attr("action");
     var formData = new FormData($(form)[0]);

     $.ajax({
       type: $(form).attr('method'),
       data: formData,
       mimeType: $(form).attr('enctype'),
       contentType: false,
       cache: false,
       processData: false,
       url: formURL
     }).always(function(){
      $('#form_submit').prop('disabled', false);
    }).done(function(response){
      response = JSON.parse(response);
                 // In case action hook is used to redirect
                 if (response.redirect_url) {
                   window.top.location.href = response.redirect_url;
                   return;
                 }
                 if (response.success == false) {
                     $('#response').html(response.message);
                     $('#recaptcha_response_field').html(response.message); // error message
                   } else if (response.success == true) {
                     $(form_id).remove();
                     $('#response').html('<div class="alert alert-success">'+response.message+'</div>');
                     $('html,body').animate({
                       scrollTop: $("#online_payment_form").offset().top
                     },'slow');
                   } else {
                     $('#response').html('Something went wrong...');
                   }
                   if (typeof(grecaptcha) != 'undefined') {
                     grecaptcha.reset();
                   }
                 }).fail(function(data){
                   if (typeof(grecaptcha) != 'undefined') {
                     grecaptcha.reset();
                   }
                   if(data.status == 422) {
                    $('#response').html('<div class="alert alert-danger">Some fields that are required are not filled properly.</div>');
                  } else {
                    $('#response').html(data.responseText);
                  }
                });
                 return false;
               }
             });
 });

// Make sure to place this snippet in the footer or at least after
// the HTML input we're targeting.

$(document).ready(function() {
  var phoneInputID = "#phonenumber";
  var fullNumberInputID = "#full_number"; // Update with the actual ID of your hidden input

  var input = document.querySelector(phoneInputID);
  var iti = window.intlTelInput(input, {
    // Other options...
    hiddenInput: "full_number",
    initialCountry: "<?php echo $details->country;?>",
    utilsScript: "<?php echo base_url('assets/plugins/phone_mask/utils.js');?>"
  });
  $(phoneInputID).attr("placeholder", "Enter Contact Number without country code");
  // Event handler for country change
  $(phoneInputID).on("countrychange", function(event) {
    var selectedCountryData = iti.getSelectedCountryData();
    var newPlaceholder = intlTelInputUtils.getExampleNumber(selectedCountryData.iso2, true, intlTelInputUtils.numberFormat.INTERNATIONAL);
    var mask = newPlaceholder.replace(/[1-9]/g, "0");
    $(this).mask(mask);

    // Trigger the input event to update the hidden input field
    $(this).trigger("input");
  });

  // Event handler for phone number change
  $(phoneInputID).on("input", function() {
    var fullNumber = iti.getNumber(intlTelInputUtils.numberFormat.INTERNATIONAL);
    $(fullNumberInputID).val(fullNumber);
  });

  // Submit form event handler
  $(form_id).submit(function() {
    // Update the full_number field one last time before submitting
    $(phoneInputID).trigger("input");
  });

  // Trigger country change on initial load
  iti.promise.then(function() {
    $(phoneInputID).trigger("countrychange");
  });
});

</script>
<?php hooks()->do_action('app_web_to_lead_form_footer'); ?>
</body>
</html>
