<?php

defined('BASEPATH') or exit('No direct script access allowed');
// 5.6 mysql version don't have the ANY_VALUE function implemented.
$v = $this->ci->db->query('SELECT VERSION() as version')->row();

$roundTimesheets = get_option('round_off_task_timer_option') != 0;

$additionalSelect = array_filter([
    db_prefix() . 'notifications.id',
    'date',
    'tblnotifications.description',
    'fromuserid',
    'fromclientid',
    'from_fullname',
    'tbltasks.id as task_id',
    'tbltasks.name as task_name',
    'additional_data',
    's1.staffid  AS default_assignee_id',
    'CONCAT_WS(" ", `s1`.`firstname`, `s1`.`lastname`) AS default_assignee_name',
    's2.staffid  AS default_follower_id',
    'CONCAT_WS(" ", `s2`.`firstname`, `s2`.`lastname`) AS default_follower_name',
    
]);

 // echo "<pre>";
 // print_r($this->ci->input->post()); exit;
$staffIdSelect = '';
if ($v && strpos($v->version, '5.7') !== false) {
    $staffIdSelect = 'ANY_VALUE(staff_id) as staff_id';
    foreach ($additionalSelect as $key => $column) {
        if ($key !== 0) {
            $additionalSelect[$key] = 'ANY_VALUE(' . $column . ') as ' . $column;
        } else {
            // causing errors for ambigious column
            $additionalSelect[$key] = 'ANY_VALUE(' . $column . ') as id';
        }
    }

    $aColumns = array_values(array_filter([
        'ANY_VALUE(name) as name',
        'ANY_VALUE((SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'taskstimers.id and rel_type="timesheet" ORDER by tag_order ASC)) as tags',
        !$roundTimesheets ? 'ANY_VALUE(start_time) as start_time' : '',
        !$roundTimesheets ? 'ANY_VALUE(end_time) as end_time' : '',
        'ANY_VALUE(note) as note',
        'ANY_VALUE(' . tasks_rel_name_select_query() . ') as rel_name',
        'ANY_VALUE(end_time - start_time) as time_h',
        'ANY_VALUE(end_time - start_time) as time_d',
    ]));
} else {
    $staffIdSelect = 'staff_id';

    $aColumns = array_values(array_filter([
        
        'tblnotifications.description',
        'fromuserid',
        'fromclientid',
        'date',
        'from_fullname',
    ]));
}

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'notifications';

$join = [];
 //if ($this->ci->input->post('course_id')) { // check if user seelect specific course or not
    $join = [
        'LEFT JOIN ' . db_prefix() . 'tasks ON tblnotifications.link LIKE "#taskid=%" AND SUBSTRING_INDEX(tblnotifications.link, "=", -1) = tbltasks.id',
        'LEFT JOIN ' . db_prefix() . 'task_assigned ta ON tblnotifications.link LIKE "#taskid=%" AND SUBSTRING_INDEX(tblnotifications.link, "=", -1) = ta.taskid AND ta.default_assignee = 1',
        'LEFT JOIN ' . db_prefix() . 'task_followers tf ON tblnotifications.link LIKE "#taskid=%" AND SUBSTRING_INDEX(tblnotifications.link, "=", -1) = tf.taskid AND tf.default_follower = 1',
        'LEFT JOIN ' . db_prefix() . 'staff s1 ON ta.staffid = s1.staffid',
        'LEFT JOIN ' . db_prefix() . 'staff s2 ON tf.staffid = s2.staffid'        
    ];
 // }else{
 //    $join = [
 //        'LEFT JOIN ' . db_prefix() . 'tasks ON ' . db_prefix() . 'tasks.id = ' . db_prefix() . 'taskstimers.task_id',
 //        //'LEFT OUTER JOIN ' . db_prefix() . 'staff st ON ' . db_prefix() . 'st.staffid = ' . db_prefix() . 'taskstimers.updated_by',
 //       ];
 // }

$where = [];

$staff_id = false;

// if ($this->ci->input->post('staff_id')) {
//     $staff_id = implode(',', $this->ci->input->post('staff_id'));
// } elseif ($view_all == false) {
//     $staff_id = get_staff_user_id();
// }



// if ($this->ci->input->post('course_id')) {
     array_push($where, 'AND tblnotifications.description = "not_task_status_changed"');
// } 

if ($staff_id != false) {
    $where = [
        'AND staff_id IN(' . $this->ci->db->escape_str($staff_id).')',
    ];
}

if ($this->ci->input->post('follower_id')) {
    $follower_id = implode(',', $this->ci->input->post('follower_id'));
    $where = [
        'AND current_follower IN(' . $this->ci->db->escape_str($follower_id).')',
    ];
}



if ($this->ci->input->post('teacher_feedback')) {
    array_push($where, 'AND teacher_feedback IN ('.implode(',',$this->ci->input->post('teacher_feedback')).')');
}

if ($this->ci->input->post('class_id')) {
    array_push($where, 'AND task_id  IN ('.implode(',',$this->ci->input->post('class_id')).')');
}

if ($this->ci->input->post('timesheet_status')) {
    array_push($where, 'AND class_status IN ('.implode(',', $this->ci->input->post('timesheet_status')).')');
}


//array_push($where, 'AND task_id != 0');

$filter = $this->ci->input->post('range');
if ($filter != 'period') {
    if ($filter == 'today') {
        $beginOfDay = strtotime('midnight');
        $endOfDay   = strtotime('tomorrow', $beginOfDay) - 1;
        //array_push($where, ' AND start_time BETWEEN ' . $beginOfDay . ' AND ' . $endOfDay);
    } elseif ($filter == 'this_month') {
        $beginThisMonth = date('Y-m-01');
        $endThisMonth   = date('Y-m-t 23:59:59');
        //array_push($where, ' AND start_time BETWEEN ' . strtotime($beginThisMonth) . ' AND ' . strtotime($endThisMonth));
    } elseif ($filter == 'last_month') {
        $beginLastMonth = date('Y-m-01', strtotime('-1 MONTH'));
        $endLastMonth   = date('Y-m-t 23:59:59', strtotime('-1 MONTH'));
        //array_push($where, ' AND start_time BETWEEN ' . strtotime($beginLastMonth) . ' AND ' . strtotime($endLastMonth));
    } elseif ($filter == 'this_week') {
        $beginThisWeek = date('Y-m-d', strtotime('monday this week'));
        $endThisWeek   = date('Y-m-d 23:59:59', strtotime('sunday this week'));
        //array_push($where, ' AND start_time BETWEEN ' . strtotime($beginThisWeek) . ' AND ' . strtotime($endThisWeek));
    } elseif ($filter == 'last_week') {
        $beginLastWeek = date('Y-m-d', strtotime('monday last week'));
        $endLastWeek   = date('Y-m-d 23:59:59', strtotime('sunday last week'));
       // array_push($where, ' AND start_time BETWEEN ' . strtotime($beginLastWeek) . ' AND ' . strtotime($endLastWeek));
    }
} else {
    $start_date = to_sql_date($this->ci->input->post('period-from'));
    $end_date   = to_sql_date($this->ci->input->post('period-to'));
    array_push($where, ' AND start_time BETWEEN ' . strtotime($start_date . ' 00:00:00') . ' AND ' . strtotime($end_date . ' 23:59:00'));
}

$result = data_tables_init(
    $aColumns,
    $sIndexColumn,
    $sTable,
    $join,
    $where,
    $additionalSelect,
    ($this->ci->input->post('group_by_task') ? 'GROUP BY task_id' : '')
);
// echo "<pre>";
// print_r($result); exit;
$output  = $result['output'];
$rResult = $result['rResult'];
//echo $this->ci->last->query(); exit;
// echo "<pre>";
// print_r($rResult); exit;

foreach ($rResult as $aRow) {
    $row = [];
    
    $row[] =  '<a href="' . admin_url('tasks/view/' . $aRow['task_id']) . '" onclick="init_task_modal(' . $aRow['task_id'] . '); return false;">' . $aRow['task_name'] .'</a>';;
    if ($view_all === true) {
        if($aRow['fromuserid']){
            $row[] = '<a href="' . admin_url('staff/member/' . $aRow['fromuserid']) . '" target="_blank">' . get_staff_full_name($aRow['fromuserid']) . '</a>';  
        }else{
             $row[] = '';  
        }
        
    }


    
    $row[] =  date('d-m-Y',strtotime($aRow['date']));
    
    
    $additional_data = '';
    if (!empty($aRow['additional_data'])) {
        $additional_data = unserialize($aRow['additional_data']);
        $x               = 0;
        foreach ($additional_data as $data) {
            if (strpos($data, '<lang>') !== false) {
                $lang = get_string_between($data, '<lang>', '</lang>');
                $temp = _l($lang);
                if (strpos($temp, 'project_status_') !== false) {
                    $status = get_project_status_by_id(strafter($temp, 'project_status_'));
                    $temp   = $status['name'];
                }
                $additional_data[$x] = $temp;
            }
            $x++;
        }
    }
    $row[] = _l($aRow['description'], $additional_data);
       
    
    $row[] = '<a href="' . admin_url('staff/member/' . $aRow['default_assignee_id']) . '" target="_blank">' .$aRow['default_assignee_name']. '</a>';
    $row[] = '<a href="' . admin_url('staff/member/' . $aRow['default_follower_id']) . '" target="_blank">' .$aRow['default_follower_name']. '</a>';  
   
    $output['aaData'][] = $row;
}

