<?php

defined('BASEPATH') or exit('No direct script access allowed');

$hasPermissionEdit   = has_permission('tasks', '', 'edit');
$hasPermissionDelete = has_permission('tasks', '', 'delete');
$tasksPriorities     = get_tasks_priorities();



$sIndexColumn = 'id';
$sTable       = db_prefix() . 'tasks';

$where = [];
//////////////////////////////////
    if ($this->ci->input->post('day') && $this->ci->input->post('day') != 'All') {
        $day = $this->ci->input->post('day');
        $join1 = 'JOIN '.db_prefix().'task_timings ON '.db_prefix().'tasks.id = '.db_prefix().'task_timings.task_id AND '.db_prefix().'task_timings.day = "'.$day.'" AND is_deleted = 0';
        $aColumns = [
                        '1', // bulk actions
                        db_prefix() . 'tasks.id as id',
                        db_prefix() . 'tasks.name as task_name',
                        'status',
                        db_prefix() .'task_timings.time as task_time',
                        'startdate',
                        //'task_time',
                        'task_days',
                        'task_duration',
                        'duedate',
                        get_sql_select_task_asignees_full_names() . ' as assignees',
                        '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'tasks.id and rel_type="task" ORDER by tag_order ASC) as tags',
                        'priority',
                    ];
    }elseif($this->ci->input->post('day') && $this->ci->input->post('day') == 'All'){
        $join1 = '';
        $aColumns = [
                        '1', // bulk actions
                        db_prefix() . 'tasks.name as task_name',
                        'status',
                       // db_prefix() .'task_timings.time as task_time',
                        'startdate',
                        //'task_time',
                        db_prefix() . 'tasks.id as id',
                        'task_days',

                        'task_duration',
                        'duedate',
                        get_sql_select_task_asignees_full_names() . ' as assignees',
                        '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'tasks.id and rel_type="task" ORDER by tag_order ASC) as tags',
                        'priority',
                    ];
    }else{
        $current_day = date('D');
   
        $join1 = 'JOIN '.db_prefix().'task_timings ON '.db_prefix().'tasks.id = '.db_prefix().'task_timings.task_id AND '.db_prefix().'task_timings.day = "'.$current_day.'" AND is_deleted = 0';
        $aColumns = [
                        '1', // bulk actions
                        db_prefix() . 'tasks.id as id',
                        db_prefix() . 'tasks.name as task_name',
                        'status',
                        db_prefix() .'task_timings.time as task_time',
                        'startdate',
                        //'task_time',
                        'task_days',
                        'task_duration',
                        'duedate',
                        get_sql_select_task_asignees_full_names() . ' as assignees',
                        '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'tasks.id and rel_type="task" ORDER by tag_order ASC) as tags',
                        'priority',
                    ];
    }
//////////////////////////////////////////////

$join  = [$join1];

include_once(APPPATH . 'views/admin/tables/includes/tasks_filter.php');

array_push($where, 'AND CASE WHEN rel_type="project" AND rel_id IN (SELECT project_id FROM ' . db_prefix() . 'project_settings WHERE project_id=rel_id AND name="hide_tasks_on_main_tasks_table" AND value=1) THEN rel_type != "project" ELSE 1=1 END');
if ($this->ci->input->post('day') && $this->ci->input->post('day') != 'All') {
    $day = $this->ci->input->post('day');
    array_push($where, 'AND FIND_IN_SET("' . $day . '" ,task_days) >0');
}

$custom_fields = get_table_custom_fields('tasks');

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, '(SELECT value FROM ' . db_prefix() . 'customfieldsvalues WHERE ' . db_prefix() . 'customfieldsvalues.relid=' . db_prefix() . 'tasks.id AND ' . db_prefix() . 'customfieldsvalues.fieldid=' . $field['id'] . ' AND ' . db_prefix() . 'customfieldsvalues.fieldto="' . $field['fieldto'] . '" LIMIT 1) as ' . $selectAs);
}

$aColumns = hooks()->apply_filters('tasks_table_sql_columns', $aColumns);
// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}

$result = data_tables_init(
    $aColumns,
    $sIndexColumn,
    $sTable,
    $join,
    $where,
    [
        'rel_type',
        'rel_id',
        'recurring',
        tasks_rel_name_select_query() . ' as rel_name',
        'billed',
        '(SELECT staffid FROM ' . db_prefix() . 'task_assigned WHERE taskid=' . db_prefix() . 'tasks.id AND staffid=' . get_staff_user_id() . ') as is_assigned',
        get_sql_select_task_assignees_ids() . ' as assignees_ids',
        '(SELECT staffid FROM '.db_prefix().'task_assigned WHERE taskid = '.db_prefix().'tasks.id AND default_assignee = 1) as default_assignee',
        '(SELECT MAX(id) FROM ' . db_prefix() . 'taskstimers WHERE task_id=' . db_prefix() . 'tasks.id and staff_id=' . get_staff_user_id() . ' and end_time IS NULL) as not_finished_timer_by_current_staff',
        '(SELECT staffid FROM ' . db_prefix() . 'task_assigned WHERE taskid=' . db_prefix() . 'tasks.id AND staffid=' . get_staff_user_id() . ') as current_user_is_assigned',
        '(SELECT CASE WHEN addedfrom=' . get_staff_user_id() . ' AND is_added_from_contact=0 THEN 1 ELSE 0 END) as current_user_is_creator',
    ]
);

$output  = $result['output'];

$rResult = $result['rResult'];
$bottom_array = [];
// echo "<pre>";
// print_r($rResult); exit;
foreach ($rResult as $aRow) {

    $time_total = 0;
    foreach (explode(':', $aRow['task_time']) as $key => $each) {
        if ($aRow['task_duration'] == 'one_hour') {
            if ($key == 0) {
                $each += 1;
            }
        } else {
            if ($key == 1) {
                $each += 30;
            }
        }
        $time_total .= $each;
        
    }

    $now_total = 0;
    foreach (explode(':', date('H:i:s')) as $each) {
        $now_total .= $each;
    }
    $flag = false;
    if ($now_total > $time_total) {
        $flag = true;
    }


    $row = [];

    $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';

    $row[] = '<a href="' . admin_url('tasks/view/' . $aRow['id']) . '" onclick="init_task_modal(' . $aRow['id'] . '); return false;">' . $aRow['id'] . '</a>';

    $outputName = '';

    if ($aRow['not_finished_timer_by_current_staff']) {
        $outputName .= '<span class="pull-left text-danger"><i class="fa fa-clock-o fa-fw"></i></span>';
    }

    $outputName .= '<a href="' . admin_url('tasks/view/' . $aRow['id']) . '" class="display-block main-tasks-table-href-name' . (!empty($aRow['rel_id']) ? ' mbot5' : '') . '" onclick="init_task_modal(' . $aRow['id'] . '); return false;">' . $aRow['task_name'] . '</a>';

    if ($aRow['rel_name']) {
        $relName = task_rel_name($aRow['rel_name'], $aRow['rel_id'], $aRow['rel_type']);

        $link = task_rel_link($aRow['rel_id'], $aRow['rel_type']);
        $staff = get_staff();
        if ($staff->admin == 1) {
            $outputName .= '<span class="hide"> - </span><a class="text-muted task-table-related" data-toggle="tooltip" title="' . _l('task_related_to') . '" href="' . $link . '">' . $relName . '</a>';
        } else {
            $outputName .= '<span class="hide"> - </span><a class="text-muted task-table-related" data-toggle="tooltip" title="' . _l('task_related_to') . '" href="' . $link . '">' . explode('-', $relName)[0] . '</a>';
        }
    }

    if ($aRow['recurring'] == 1) {
        $outputName .= '<br /><span class="label label-primary inline-block mtop4"> ' . _l('recurring_task') . '</span>';
    }

    $outputName .= '<div class="row-options">';

    $class = 'text-success bold';
    $style = '';

    $tooltip = '';
    if ($aRow['billed'] == 1 || !$aRow['is_assigned'] || $aRow['status'] == Tasks_model::STATUS_COMPLETE) {
        $class = 'text-dark disabled';
        $style = 'style="opacity:0.6;cursor: not-allowed;"';
        if ($aRow['status'] == Tasks_model::STATUS_COMPLETE) {
            $tooltip = ' data-toggle="tooltip" data-title="' . format_task_status($aRow['status'], false, true) . '"';
        } elseif ($aRow['billed'] == 1) {
            $tooltip = ' data-toggle="tooltip" data-title="' . _l('task_billed_cant_start_timer') . '"';
        } elseif (!$aRow['is_assigned']) {
            $tooltip = ' data-toggle="tooltip" data-title="' . _l('task_start_timer_only_assignee') . '"';
        }
    }

    if ($aRow['not_finished_timer_by_current_staff']) {
        //$outputName .= '<a href="#" class="text-danger tasks-table-stop-timer" onclick="timer_action(this,' . $aRow['id'] . ',' . $aRow['not_finished_timer_by_current_staff'] . '); return false;">' . _l('task_stop_timer') . '</a>';
    } else {
        $current_day_time = $this->ci->tasks_model->get_current_daytime($aRow['id'],get_staff_user_id()); 
        ///////////////

        if($current_day_time){
            $datetime1 = strtotime(date('Y-m-d').' '.$current_day_time);
            $datetime2 = strtotime(date('Y-m-d H:i:s'));
            
            $duration_minute = $aRow['task_duration'];
          

            $datetime_duration  = strtotime(date('Y-m-d').' '.$current_day_time.'+'.$duration_minute.' minutes ');
            

            $interval  = $datetime_duration - $datetime2;
            $minutes   = round($interval / 60);
           // echo $minutes; exit;

        }

        ////////////////
        if($aRow['duedate'] && $aRow['duedate'] != NULL){
            if((strtotime($aRow['startdate']) <= strtotime(date('Y-m-d')) && strtotime($$aRow['duedate']) >= strtotime(date('Y-m-d'))) && $aRow['is_assigned'] && $current_day_time && !$this->ci->tasks_model->is_timer_started($aRow['id']) && (($minutes <= $duration_minute + 5 &&  $minutes >= 0))) {
                $outputName .= '<span' . $tooltip . ' ' . $style . '>
                   <a href="#" class="' . $class . ' tasks-table-start-timer" id="class_button'.$aRow['id'].'" onclick="start_class_enlist(' . $aRow['id'] . '); return false;">' . _l('Start Class') . '</a>
                   </span><input type="hidden" name="class_time" class="class_time" value="'.$classTime.'">';
            }else{
                $outputName .= '<span' . $tooltip . ' ' . $style . ' class="hidden" id="class_vis_'.$aRow['id'].'">
               <a href="#" class="' . $class . ' tasks-table-start-timer" id="class_button'.$aRow['id'].'" onclick="start_class_enlist(' . $aRow['id'] . '); return false;">' . _l('Start Class') . '</a>
               </span><input type="hidden" name="class_time" class="class_time" value="'.$classTime.'">';
            } 
        }else{
            if(strtotime($aRow['startdate']) <= strtotime(date('Y-m-d')) && $aRow['is_assigned'] && $current_day_time && !$this->ci->tasks_model->is_timer_started($aRow['id']) && (($minutes <= $duration_minute + 5 &&  $minutes >= 0))) {
                $outputName .= '<span' . $tooltip . ' ' . $style . '>
                   <a href="#" class="' . $class . ' tasks-table-start-timer" id="class_button'.$aRow['id'].'" onclick="start_class_enlist(' . $aRow['id'] . '); return false;">' . _l('Start Class') . '</a>
                   </span><input type="hidden" name="class_time" class="class_time" value="'.$classTime.'">';
            }else{
                $outputName .= '<span' . $tooltip . ' ' . $style . ' class="hidden" id="class_vis_'.$aRow['id'].'">
               <a href="#" class="' . $class . ' tasks-table-start-timer" id="class_button'.$aRow['id'].'" onclick="start_class_enlist(' . $aRow['id'] . '); return false;">' . _l('Start Class') . '</a>
               </span><input type="hidden" name="class_time" class="class_time" value="'.$classTime.'">';
            } 
        }
        
       
    }



    if ($hasPermissionEdit) {
        $outputName .= '<span class="text-dark"> | </span><a href="#" onclick="edit_task(' . $aRow['id'] . '); return false">' . _l('edit') . '</a>';
    }

    if ($hasPermissionDelete) {
        $outputName .= '<span class="text-dark"> | </span><a href="' . admin_url('tasks/delete_task/' . $aRow['id']) . '" class="text-danger _delete task-delete">' . _l('delete') . '</a>';
    }
    $outputName .= '</div>';

    $row[] = $outputName;

    $canChangeStatus = ($aRow['current_user_is_creator'] != '0' || $aRow['current_user_is_assigned'] || has_permission('tasks', '', 'edit'));
    $status          = get_task_status_by_id($aRow['status']);
    $outputStatus    = '';

    $outputStatus .= '<span class="inline-block label" style="color:' . $status['color'] . ';border:1px solid ' . $status['color'] . '" task-status-table="' . $aRow['status'] . '">';

    $outputStatus .= $status['name'];

    if ($canChangeStatus) {
        $outputStatus .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
        $outputStatus .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableTaskStatus-' . $aRow['id'] . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
        $outputStatus .= '<span data-toggle="tooltip" title="' . _l('ticket_single_change_status') . '"><i class="fa fa-caret-down" aria-hidden="true"></i></span>';
        $outputStatus .= '</a>';

        $outputStatus .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableTaskStatus-' . $aRow['id'] . '">';
        foreach ($task_statuses as $taskChangeStatus) {
            if ($aRow['status'] != $taskChangeStatus['id']) {
                $outputStatus .= '<li>
                  <a href="#" onclick="task_mark_as(' . $taskChangeStatus['id'] . ',' . $aRow['id'] . '); return false;">
                     ' . _l('task_mark_as', $taskChangeStatus['name']) . '
                  </a>
               </li>';
            }
        }
        $outputStatus .= '</ul>';
        $outputStatus .= '</div>';
    }

    $outputStatus .= '</span>';

    $row[] = $outputStatus;

    
    if($this->ci->input->post('day') && $this->ci->input->post('day') == 'All'){
        $row[] = '';
    }else{
        $row[] = date('h:i A ', strtotime($aRow['task_time']));
    }

    

    //$row[] = $now_total.' '.$time_total;
    $days = [];
    for ($i = 0; $i < 7; $i++) {
        $next_day = date('D', strtotime(' +' . $i . ' day'));
        if (in_array($next_day, explode(',', $aRow['task_days']))) {
            array_push($days, $next_day);
        }
    }

    $row[] = implode(',', $days);
    $duration = '';
    switch ($aRow['task_duration']) {
        case 30:
            $duration = "30 Minutes";
            break;
        case 45:
            $duration = "45 Minutes";
            break;
        default:
            $duration = "1 Hour";
            break;
    }

    $row[] =  _l($duration);

    $row[] = _d($aRow['startdate']);

    $row[] = _d($aRow['duedate']);

    ////////////////////////////////////Inorder to show default assignee some logic changed bu umar /////////////////

    $outputAssignees = '';
    $exportAssignees = '';

    $assignees   = explode(',', $aRow['assignees']);
    $assigneeIds = explode(',', $aRow['assignees_ids']);
    
    foreach ($assignees as $key => $assigned) {
        $is_default_assignee = '';
        $assignee_id = $assigneeIds[$key];
        if($assignee_id == $aRow['default_assignee']){
            $is_default_assignee = '(Default Assignee)';
        }
        $assignee_id = trim($assignee_id);
        if ($assigned != '') {
            $outputAssignees .= '<a href="' . admin_url('profile/' . $assignee_id) . '">' .
                staff_profile_image($assignee_id, [
                   'staff-profile-image-small mright5',
                ], 'small', [
                    'data-toggle' => 'tooltip',
                    'data-title'  => $assigned.' '.$is_default_assignee,
                ]) . '</a>';
            $exportAssignees .= $assigned . ', ';
        }
    }
    if ($exportAssignees != '') {
        $outputAssignees .= '<span class="hide">' . mb_substr($exportAssignees, 0, -2) . '</span>';
    }

    $row[] = $outputAssignees;
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////below is previous logic//////////////////////////////////////////
    //$row[] = format_members_by_ids_and_names($aRow['assignees_ids'], $aRow['assignees']);

    $outputPriority = '<span style="color:' . task_priority_color($aRow['priority']) . ';" class="inline-block">' . task_priority($aRow['priority']);

    if (has_permission('tasks', '', 'edit') && $aRow['status'] != Tasks_model::STATUS_COMPLETE) {
        $outputPriority .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
        $outputPriority .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableTaskPriority-' . $aRow['id'] . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
        $outputPriority .= '<span data-toggle="tooltip" title="' . _l('task_single_priority') . '"><i class="fa fa-caret-down" aria-hidden="true"></i></span>';
        $outputPriority .= '</a>';

        $outputPriority .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableTaskPriority-' . $aRow['id'] . '">';
        foreach ($tasksPriorities as $priority) {
            if ($aRow['priority'] != $priority['id']) {
                $outputPriority .= '<li>
                  <a href="#" onclick="task_change_priority(' . $priority['id'] . ',' . $aRow['id'] . '); return false;">
                     ' . $priority['name'] . '
                  </a>
               </li>';
            }
        }
        $outputPriority .= '</ul>';
        $outputPriority .= '</div>';
    }

    $outputPriority .= '</span>';
    //$row[] = $outputPriority;

    // Custom fields add values
    foreach ($customFieldsColumns as $customFieldColumn) {
        $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
    }

    $row['DT_RowClass'] = 'has-row-options';

    if ((!empty($aRow['duedate']) && $aRow['duedate'] < date('Y-m-d')) && $aRow['status'] != Tasks_model::STATUS_COMPLETE) {
        $row['DT_RowClass'] .= ' text-danger';
    }

    $row = hooks()->apply_filters('tasks_table_row_data', $row, $aRow);

    if ($flag == true) {
        $flag = false;
        array_push($bottom_array, $row);
    } else {

        $output['aaData'][] = $row;
    }
}
$index = count($bottom_array)-1;
foreach($bottom_array as $key=>$each_row)
{
    $output['aaData'][] = $bottom_array[$key];
    $index --;
}

// echo "<pre>";
// print_r($output); exit;