<?php
defined('BASEPATH') or exit('No direct script access allowed');

function send_whatsapp_message($url = '', $app_key = '',$auth_key = '',$contact_number = '', $template_id = ''){
	$curl = curl_init();

	curl_setopt_array($curl, array(
		CURLOPT_URL => $url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS => array(
			'appkey' => $app_key,
			'authkey' => $auth_key,
			'to' => $contact_number,
			'template_id' => $template_id,
		),
	));

	$response = curl_exec($curl);

	curl_close($curl);
	return $response;
}
function whatsapp_server_url(){
	$url = 'https://waserver.pro/api/create-message';
	return $url;
}
function check_message_sent($id = '',$type = ''){
	$ci =& get_instance();
	$ci->load->database();
	return $ci->db->get_where(db_prefix().'whatsapp_message_log',array('rel_id' => $id,'type' => $type))->result();
}

function create_whatsapp_message_log($data){
	$ci =& get_instance();
	$ci->load->database();
	$insert =  $ci->db->insert(db_prefix().'whatsapp_message_log',$data);
	if($insert){
		return true;
	}else{
		return false;
	}
}

function create_whatsapp_activity_log($data){
	$ci =& get_instance();
	$ci->load->database();
	$insert = $ci->db->insert(db_prefix().'_whatsapp_activity_log',$data)->result();
	if($insert){
		return true;
	}else{
		return false;
	}
}

function getUserIP() {
    $headers_to_check = array(
        'HTTP_X_FORWARDED_FOR',
        'HTTP_CLIENT_IP',
        'REMOTE_ADDR'
    );

    foreach ($headers_to_check as $header) {
        if (array_key_exists($header, $_SERVER) && !empty($_SERVER[$header])) {
            $ips = explode(',', $_SERVER[$header]);
            $ip = trim($ips[0]);
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }

    return 'Unknown';
}



