<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Timetable By <a href="https://theperfectsol.com/shop/" target="_blank">ThePerfectSol</a>
Description: Timetable for Perfex CRM 
Version: 1.1.1
Requires at least: 2.3.*
*/

define('TIMETABLE_MODULE', 'timetable');

/**
 * Register activation module hook
 */
register_activation_hook(TIMETABLE_MODULE, 'timetable_module_activation_hook');

hooks()->add_action('admin_init', 'timetable_init_menu_items');


function timetable_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}
/**
 * Load the module helper
 */
get_instance()->load->helper(TIMETABLE_MODULE . '/timetable');

// app_init_get_a_quote_webhook_tabs();

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(TIMETABLE_MODULE, [TIMETABLE_MODULE]);

function timetable_init_menu_items()
{
    $CI = &get_instance();

    $CI = &get_instance();
    $CI->app_menu->add_sidebar_menu_item('timetable', [
        'name'     => _l('timetable'),
        'href'     => admin_url('timetable'),
        'icon'     => 'fa fa-calendar',
        'position' => 5,
    ]);

    if (is_admin()) {
        $CI->app_menu->add_sidebar_menu_item('fee_statuses', [
            'name'     => _l('fee_statuses'),
            'href'     => admin_url('timetable/fee_statuses'),
            'icon'     => 'fa fa-credit-card',
            'position' => 5,
        ]);
    }
}
