<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <div class="row">
         <div class="col-md-12">
            <div class="panel_s">
               <div class="panel-body">
                  <div class="row _buttons">
                     <div class="col-md-8">
                        <?php if (has_permission('tasks', '', 'create')) { ?>
                           <a href="#" onclick="new_task(<?php if ($this->input->get('project_id')) {
                                                            echo "'" . admin_url('tasks/task?rel_id=' . $this->input->get('project_id') . '&rel_type=project') . "'";
                                                         } ?>); return false;" class="btn btn-info pull-left new"><?php echo _l('new_task'); ?></a>
                        <?php } ?>
                        <a href="<?php if (!$this->input->get('project_id')) {
                                    echo admin_url('tasks/switch_kanban/' . $switch_kanban);
                                 } else {
                                    echo admin_url('projects/view/' . $this->input->get('project_id') . '?group=project_tasks');
                                 }; ?>" class="btn btn-default mleft10 pull-left hidden-xs">
                           <?php if ($switch_kanban == 1) {
                              echo _l('switch_to_list_view');
                           } else {
                              echo _l('leads_switch_to_kanban');
                           }; ?>
                        </a>
                     </div>
                     <div class="col-md-4">
                        <?php if ($this->session->has_userdata('tasks_kanban_view') && $this->session->userdata('tasks_kanban_view') == 'true') { ?>
                           <div data-toggle="tooltip" data-placement="bottom" data-title="<?php echo _l('search_by_tags'); ?>">
                              <?php echo render_input('search', '', '', 'search', array('data-name' => 'search', 'onkeyup' => 'tasks_kanban();', 'placeholder' => _l('search_tasks')), array(), 'no-margin') ?>
                           </div>
                        <?php } else { ?>
                           <?php $this->load->view('admin/tasks/tasks_filter_by', array('view_table_name' => '.table-tasks')); ?>
                           <a href="<?php echo admin_url('tasks/detailed_overview'); ?>" class="btn btn-success pull-right mright5"><?php echo _l('detailed_overview'); ?></a>
                        <?php } ?>
                     </div>
                  </div>
                  <hr class="hr-panel-heading hr-10" />
                  <div class="clearfix"></div>
                  <div class="row">
                     <div class="col-md-12">
                        <p class="bold"><?php echo _l('filter_by'); ?></p>
                     </div>
                     <div class="col-md-3">
                        <div class="form-group">
                           <?php echo render_select('days_filter', [['name' => 'All'], ['name' => 'Mon'], ['name' => 'Tue'], ['name' => 'Wed'], ['name' => 'Thu'], ['name' => 'Fri'], ['name' => 'Sat'], ['name' => 'Sun'],], ['name', 'name'], 'task_days', date('D'), [], [], '', '', false); ?>
                        </div>
                     </div>
                  </div>
                  <hr class="hr-panel-heading hr-10" />
                  <div class="clearfix"></div>
                  <?php
                  if ($this->session->has_userdata('tasks_kanban_view') && $this->session->userdata('tasks_kanban_view') == 'true') { ?>
                     <div class="kan-ban-tab" id="kan-ban-tab" style="overflow:auto;">
                        <div class="row">
                           <div id="kanban-params">
                              <?php echo form_hidden('project_id', $this->input->get('project_id')); ?>
                           </div>
                           <div class="container-fluid">
                              <div id="kan-ban"></div>
                           </div>
                        </div>
                     </div>
                  <?php } else { ?>
                     <?php $this->load->view('admin/tasks/_summary', array('table' => '.table-tasks')); ?>
                     <a href="#" data-toggle="modal" data-target="#tasks_bulk_actions" class="hide bulk-actions-btn table-btn" data-table=".table-tasks"><?php echo _l('bulk_actions'); ?></a>
                     <?php $this->load->view('admin/tasks/_table', array('bulk_actions' => true)); ?>
                     <?php $this->load->view('admin/tasks/_bulk_actions'); ?>
                  <?php } ?>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<?php init_tail(); ?>
<script>
   taskid = '<?php echo $taskid; ?>';
   $(function() {

      var table_tasks = $('.table-tasks');
      var tasksTableNotSortable = [0]; // bulk actions
      var tasksTableURL = admin_url + 'tasks/table';

      tasks_kanban();


      $('select[name="days_filter"]').on('change', function() {

         var TasksServerParams = {},
            h = $("._hidden_inputs._filters._tasks_filters input");
         $.each(h, function() {
            TasksServerParams[$(this).attr("name")] = '[name="' + $(this).attr("name") + '"]'
         });
         TasksServerParams['day'] = '[name="days_filter"]';


         if ($.fn.DataTable.isDataTable(table_tasks)) {
            $(table_tasks).DataTable().destroy();
         }

         initDataTable(table_tasks, tasksTableURL, tasksTableNotSortable, tasksTableNotSortable, TasksServerParams, ['5', 'asc']);
      });

   });

   function task_mark_as(status, task_id, url) {

      url = typeof(url) == 'undefined' ? 'tasks/mark_as/' + status + '/' + task_id : url;
      var taskModalVisible = $('#task-modal').is(':visible');
      url += '?single_task=' + taskModalVisible;
      $("body").append('<div class="dt-loader"></div>');
      requestGetJSON(url).done(function(response) {
         $("body").find('.dt-loader').remove();
         if (response.success === true || response.success == 'true') {

            var TasksServerParams = {},
               h = $("._hidden_inputs._filters._tasks_filters input");
            $.each(h, function() {
               TasksServerParams[$(this).attr("name")] = '[name="' + $(this).attr("name") + '"]'
            });
            TasksServerParams['day'] = '[name="days_filter"]';

            var table_tasks = $('.table-tasks');
            var tasksTableNotSortable = [0]; // bulk actions
            var tasksTableURL = admin_url + 'tasks/table';

            if ($.fn.DataTable.isDataTable(table_tasks)) {
               $(table_tasks).DataTable().destroy();
            }




            initDataTable(table_tasks, tasksTableURL, tasksTableNotSortable, tasksTableNotSortable, TasksServerParams, ['5', 'asc']);


            if (taskModalVisible) {
               _task_append_html(response.taskHtml);
            }
            if (status == 5 && typeof(_maybe_remove_task_from_project_milestone) == 'function') {
               _maybe_remove_task_from_project_milestone(task_id);
            }
            if ($('.tasks-kanban').length === 0) {
               alert_float('success', response.message);
            }
         }
      });
   }
</script>
</body>

</html>