<?php

defined('BASEPATH') or exit('No direct script access allowed');

class ClassesCrons extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('invoices_model');
        $this->load->model('credit_notes_model');
    }

    /* Get all invoices in case user go on index page */
    public function index($id = '')
    {
        
        $yesterdayDate = date('Y-m-d', strtotime('-1 day'));
        $currentDateTime = date('Y-m-d H:i:s');
        // Your SQL query
        $sql_custom = "SELECT t.id as task_id, t.name, t.task_duration, cd.time, ta.staffid as assignee_id, tf.staffid as follower_id, cd.time, cd.day,(STR_TO_DATE(CONCAT('$yesterdayDate', ' ', cd.time), '%Y-%m-%d %H:%i:%s') + INTERVAL t.task_duration MINUTE) as tts_yesterday
        FROM tbltasks t
        INNER JOIN tbltask_timings cd ON t.id = cd.task_id
            AND cd.day = LEFT(DAYNAME('$yesterdayDate'), 3)
            AND cd.is_deleted != 1
            AND cd.time < '23:59:59'
            AND (STR_TO_DATE(CONCAT('$yesterdayDate', ' ', cd.time), '%Y-%m-%d %H:%i:%s') + INTERVAL t.task_duration MINUTE) <= '$currentDateTime'
        INNER JOIN tbltask_assigned ta ON t.id = ta.taskid AND default_assignee = 1
        LEFT JOIN tbltask_followers tf ON t.id = tf.taskid AND default_follower = 1
        LEFT JOIN tbltaskstimers tt ON t.id = tt.task_id AND DATE(tt.starttime) = '$yesterdayDate'
        WHERE tt.start_time IS NULL
            AND t.startdate <= '$yesterdayDate'
            AND t.status IN (1, 4)
            AND (t.duedate IS NULL OR t.duedate >= '$yesterdayDate')
        ORDER BY t.id
        LIMIT 100";

        $data = $this->db->query($sql_custom)->result();
        if(empty($data)){
            $currentDateTime = date('Y-m-d H:i:s'); // 'YYYY-MM-DD HH:MM:SS' format

            // Your SQL query
            $sql = " SELECT t.id as task_id, t.name, t.task_duration, cd.time, ta.staffid as assignee_id, tf.staffid as follower_id, cd.time, cd.day,SUBSTRING_INDEX(TIME(ADDTIME(cd.time, SEC_TO_TIME(t.task_duration * 60))), '.', 1) as tts, TIME('$currentDateTime') 
            FROM tbltasks t
            INNER JOIN tbltask_timings cd ON t.id = cd.task_id
                AND cd.day = LEFT(DAYNAME('$currentDateTime'), 3)
                AND cd.is_deleted != 1
                AND cd.time < TIME('$currentDateTime') 
                AND SUBSTRING_INDEX(TIME(ADDTIME(cd.time, SEC_TO_TIME(t.task_duration * 60))), '.', 1) < TIME('$currentDateTime') 
            INNER JOIN tbltask_assigned ta ON t.id = ta.taskid AND default_assignee = 1
            LEFT JOIN tbltask_followers tf ON t.id = tf.taskid AND default_follower = 1
            LEFT JOIN tbltaskstimers tt ON t.id = tt.task_id AND DATE(tt.starttime) = DATE('$currentDateTime') 
            WHERE tt.start_time IS NULL
                AND t.startdate <= DATE('$currentDateTime') 
                AND t.status IN (1, 4)
                AND (t.duedate IS NULL OR t.duedate >= DATE('$currentDateTime')) 
            ORDER BY t.id
            LIMIT 100";
            $data = $this->db->query($sql)->result();
        }
       // echo $this->db->last_query(); exit;
        echo "<pre>";
        print_r($data); //exit;
       
        $insert_data = array();
        $count = 0;
        if($data){
            foreach ($data as $key => $row) {
                $crnt_day_no = date('w', strtotime(date('Y-m-d')));
                $day_of_week = date('N', strtotime($row->day));
                //echo "Current Day no == ".$crnt_day_no."<br>";
                //echo "Day Of WEEK == ".$day_of_week."<br>"; 
               // echo "Previous == ".date('N', strtotime(date('Y-m-d'). ' - 1 days'));
                $diff = '';
                if($crnt_day_no == $day_of_week){
                   // echo "IF<br>";
                   $diff = 0; 
                }elseif (date('N', strtotime(date('Y-m-d'). ' - 1 days')) == $day_of_week) {
                    $diff = 1;
                    //echo "ELSE IF<br>";
                }else{
                   // echo "ELSE<br>";
                    echo "Date Issue"; exit;
                }

                //$diff = $crnt_day_no - $day_of_week;

                $insert_data[$count]['task_id'] = $row->task_id;
                $current_date = date('Y-m-d', strtotime(date('Y-m-d'). ' - '.$diff.' days'));
                $insert_data[$count]['starttime']  = $current_date.' '.$row->time;
                $insert_data[$count]['start_date'] = date("Y-m-d H:i:s");//current date when action was performed
                $insert_data[$count]['start_time'] = strtotime($current_date.' '.$row->time);
                $insert_data[$count]['staff_id'] =  $row->assignee_id;
                $insert_data[$count]['current_assignee'] = $row->assignee_id;
                $insert_data[$count]['current_follower'] = $row->follower_id;
                $insert_data[$count]['class_status'] = 5;
                $count++;
            }    
        }
        //exit;
        if($insert_data){
            $this->db->insert_batch(db_prefix().'taskstimers',$insert_data);
        }
       // echo $this->db->last_query(); exit;
    }
    // public function update_classes(){
    //     $sql = 'SELECT tbltaskstimers.*,tbltasks.task_duration,name FROM `tbltaskstimers` JOIN tbltasks ON tbltaskstimers.task_id = tbltasks.id WHERE ADDTIME(starttime, CONCAT("00:",MINUTE(task_duration),":","00")) < endtime';
    //     $data = $this->db->query($sql)->result_array();
    //   echo "<pre>";
    //   print_r($data); //exit;
    //     foreach ($data as $row) {
            
    //         $end_time = date( "Y-m-d H:i:s", strtotime( $row['starttime'] . " +".$row['task_duration']." minutes" ) );  
    //         $this->db->where('id',$row['id']);
    //         $this->db->update('tbltaskstimers',array('endtime' => $end_time,'end_time' => strtotime($end_time)));
    //       echo date('Y-m-d H:i:s',strtotime($row['starttime']))." == ".date('Y-m-d H:i:s',$row['start_time'])."<br>";
    //       // echo $this->db->last_query()."<br>";
    //     }
    // }

}
