<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="top" data-sticky data-sticky-class="preview-sticky-header">
    <div class="container preview-sticky-container">
        <div class="row">
            <div class="col-md-12  mtop5 ">
                <div class="pull-left">
                    <b>
                        <h1><?php echo _l('wallet_amount'); ?>: <?= $client->wallet_amount ? $client->wallet_amount : 0; ?></h1>
                    </b>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="mtop15 preview-top-wrapper">
    <div class="panel_s mtop20">
        <div class="panel-body">
            <div class="col-md-6 text-left">
                <div class="col-md-6 text-left">
                    <p class="bold mbot15 font-medium"><?php echo _l('invoice_html_online_payment'); ?></p>
                    <?php echo form_open('admin/wallet/wallets/', array('id' => 'online_payment_form', 'novalidate' => true)); ?>
                    <?php $hash=''; ?>
                    <?php foreach ($payment_modes as $mode) {
                        if (!empty($mode['id'])) { ?>
                            <div class="radio radio-success online-payment-radio">
                                <input type="radio" value="<?php echo $mode['id']; ?>" id="pm_<?php echo $mode['id']; ?>" data-status="<?php echo (is_numeric($mode['id'])) ? 0 : 1; ?>" name="paymentmode">
                                <label for="pm_<?php echo $mode['id']; ?>"><?php echo $mode['name']; ?></label>
                            </div>
                            <?php if (!empty($mode['description'])) { ?>
                                <div class="mbot15">
                                    <?php echo $mode['description']; ?>
                                </div>
                    <?php }
                        }
                    } ?>

                    <div class="form-group mtop25">
                        <label for="amount" class="control-label"><?php echo _l('invoice_html_amount'); ?></label>
                        <div class="input-group">
                            <input type="number" required data-total="<?php echo $total; ?>" name="amount" class="form-control" value="<?php echo $total; ?>">
                        </div>
                    </div>
                    <div id="pay_button">
                        <input id="pay_now" type="submit" name="make_payment" class="btn btn-success" value="<?php echo _l('invoice_html_online_payment_button_text'); ?>">
                    </div>
                    <input type="hidden" name="hash" value="<?php echo $hash; ?>">
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- /////  Modal   ///// -->

<div class="modal fade" id="bank_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="no-margin">
                    <b><?php echo _l('payment_for_invoice'); ?> </b>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </h3>
            </div>
            <div class="modal-body">
                <?php echo form_open_multipart('admin/wallet/wallets/', array('class' => '', 'id' => 'cheque-upload')); ?>
                <div id="dropzone-task-comment-previews" class=" dropzone-previews"></div>
                <?php echo form_close(); ?>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info offline-payment-submit" data-dismiss="modal"><?php echo _l('submit_payment'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {

        $('#online_payment_form').appFormValidator();
        var online_payments = $('.online-payment-radio');
        if (online_payments.length == 1) {
            online_payments.find('input').prop('checked', true);
        }

        $("#online_payment_form").submit(function(event) {

            var status = $("input[name='paymentmode']:checked").data('status');
            if (status == 0) {
                event.preventDefault();
                var selectedValue = $("input[name='paymentmode']:checked").val();

                $('#bank_modal').modal('show');

            } else {

                $("#online_payment_form").submit();
            }

        });
        $('.offline-payment-submit').click(function() {
            $(this).prop('disabled', true);
            walletAttachmentDropzone.processQueue();
        });

        $('#cheque-upload').addClass('dropzone');

        walletAttachmentDropzone = new Dropzone("#cheque-upload", appCreateDropzoneOptions({
            dictDefaultMessage: "Drop cheque images here to upload",
            uploadMultiple: true,
            autoProcessQueue: false,
            addRemoveLinks: true,
            parallelUploads: 20,
            maxFiles: 20,
            paramName: 'file[]',

            sending: function(file, xhr, formData) {
                var formDataB = $('#online_payment_form').serializeArray();
                console.log(formDataB);

                for (var i = 0; i < formDataB.length; i++) {
                    formData.append(formDataB[i].name, formDataB[i].value);
                }
            },
            success: function(files, response) {
                var response = JSON.parse(response);
                if (response.success) {
                    window.location.href = admin_url + 'wallet';
                }
            }
        }));
    });
</script>