<?php
defined('BASEPATH') or exit('No direct script access allowed');
function invoice_payment($data)
{
    $CI = &get_instance();
    $extra_amount  = '';
    $invoice_amount = get_invoice_total_left_to_pay($data['invoiceid']);
    if ($data['amount'] == $invoice_amount) {
        $data['amount']  = $invoice_amount;
        $extra_amount  = 0;
    } else if ($data['amount'] > $invoice_amount) {
        $data['amount']  = $invoice_amount;
        $extra_amount  = $data['amount'] - $invoice_amount;
    } else {
        $data['amount'] = $data['amount'];
        $extra_amount  = 0;
    }
    $CI->db->where('id', $data['invoiceid']);
    $invoice = $CI->db->get(db_prefix() . 'invoices')->row();
    $CI->db->where('userid', $invoice->clientid);
    $CI->db->update(db_prefix() . 'clients', [
        'wallet_amount' => $extra_amount,
    ]);
    unset($data['make_payment']);
    unset($data['hash']);
    unset($data['wallet']);
    $CI->db->insert(db_prefix() . 'invoicepaymentrecords', $data);
    $insert_id = $CI->db->insert_id();
}

function handle_wallet_attachments($rel_id, $rel_type)
{
    $filesIDS = [];
    if (
        isset($_FILES['file']['name'])
        && ($_FILES['file']['name'] != '' || is_array($_FILES['file']['name']) && count($_FILES['file']['name']) > 0)
    ) {

        if (!is_array($_FILES['file']['name'])) {
            $_FILES['file']['name']     = [$_FILES['file']['name']];
            $_FILES['file']['type']     = [$_FILES['file']['type']];
            $_FILES['file']['tmp_name'] = [$_FILES['file']['tmp_name']];
            $_FILES['file']['error']    = [$_FILES['file']['error']];
            $_FILES['file']['size']     = [$_FILES['file']['size']];
        }

        wallet_maybe_create_upload_path(WALLET_ATTACHMENTS_FOLDER);

        $path          =  WALLET_ATTACHMENTS_FOLDER . $rel_id . '/';

        for ($i = 0; $i < count($_FILES['file']['name']); $i++) {

            if (_perfex_upload_error($_FILES['file']['error'][$i][$i])) {
                $errors[$_FILES['file']['name'][$i][$i]] = _perfex_upload_error($_FILES['file']['error'][$i][$i]);

                continue;
            }

            // Get the temp file path
            $tmpFilePath = $_FILES['file']['tmp_name'][$i][$i];
            // Make sure we have a filepath

            if (!empty($tmpFilePath) && $tmpFilePath != '') {
                $type = $_FILES['file']['type'][$i][$i];
                wallet_maybe_create_upload_path($path);
                $filename = unique_filename($path, $_FILES['file']['name'][$i][$i]);
                $newFilePath = $path . $filename;
                $file_uploaded = true;
                $CI           = &get_instance();
                $attachment   = [];
                $attachment[] = [
                    'file_name' => $filename,
                    'filetype'  => $_FILES['file']['type'][$i][$i],
                    // 'staffid' =>  get_staff_user_id(),
                    'contact_id' => 0,
                    'visible_to_customer' => 1
                ];
                $CI->misc_model->add_attachment_to_database($rel_id, $rel_type, $attachment);
                $insert_id = $CI->db->insert_id();

                $CI->db->where('id', $insert_id);
                $_attachment = $CI->db->get(db_prefix() . 'files')->row();
                $key         = $_attachment->attachment_key;
                if ($insert_id) {
                    array_push($filesIDS, $insert_id);
                } else {
                    unlink($newFilePath);

                    return false;
                }
            }
        }
    }
}

function wallet_maybe_create_upload_path($path)
{
    if (!file_exists($path)) {
        mkdir($path, 0755);
        fopen(rtrim($path, '/') . '/' . 'index.html', 'w');
    }
}

function format_transection_status($status)
{
    if ($status == '0') {

        $status = _l('invoice_status_pendding');
    } else {

        $status = _l('invoice_status_credited');
    }
    return $status;
}

