<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Family Meta Data
Description: Default module to apply changes to the Family Meta Data
Version: 2.3.0
Requires at least: 2.3.*
*/

define('FAMILY_META_DATA', 'family_meta_data');

$CI = &get_instance();

hooks()->add_action('admin_init', 'family_meta_data_init_menu_items');
hooks()->add_action('customers_table_row_data', 'table_row_data');
hooks()->add_action('customers_table_columns', 'table_columns');


function table_row_data($data)
{
   
    $CI = &get_instance();

    $CI->load->model(FAMILY_META_DATA . '/family_meta_data_model');
    $CI->load->model('Tasks/Tasks_model');
    if (staff_can('view', 'invoices')) {
    $res = $CI->family_meta_data_model->get_invoices_data($data[1]);
    // echo"<pre>";print_r($res);exit;

    $data[count($data) - 1] = '<a href="' . admin_url('clients/client/'.$data[1] .'?group=invoices').'">'.'<b>Paid</b> ' . ($res->paid ? $res->paid : 0) . ' <br><b>Unpaid</b> ' . ($res->unpaid ? $res->unpaid : 0) . ' <br> <b>Over Due</b> ' . ($res->over_due ? $res->over_due : 0).' <br> <b>Recurring</b> '. ($res->recurring ? $res->recurring : 0).'</a>';
    }

    if (staff_can('view', 'tasks')) {
    $statuses= $CI->Tasks_model->get_statuses($data[1]);
    $results = $CI->family_meta_data_model->get_tasks($data[1],$statuses);
    

    $tasks_text = '';

    foreach($statuses  as $status){
        foreach($results  as $key=> $result){
            if($key== $status['id'])
            {
                $tasks_text .= $status['name'].': '.$result.' <br>';
            }
        }
    }
    $data[count($data) - 1]=  '<a href="' . admin_url('clients/client/'.$data[1].'?group=tasks' ).'">'.$tasks_text . '</a>';

    $data[count($data) - 1] = $result;
}
    return $data;
    
}

function table_columns($data)
{
    if (staff_can('view', 'invoices')) {
        $data[] = [
            'name' => 'Invoices',
            'th_attrs' => [
                'class' => 'toggleable',
                'id' => 'th-invoices'
            ]
        ];
    }

    if (staff_can('view', 'tasks')) {
        $data[] = [
            'name' => 'Classes',
            'th_attrs' => [
                'class' => 'toggleable',
                'id' => 'th-classes'
            ]
            ];
        
    }
    return $data;

}
/**
 * Load the module helper
 */
$CI->load->helper(FAMILY_META_DATA . '/family_meta_data');

/**
 * Register activation module hook
 */
register_activation_hook(FAMILY_META_DATA, 'family_meta_data_activation_hook');

function family_meta_data_activation_hook()
{
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(FAMILY_META_DATA, [FAMILY_META_DATA]);

/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function family_meta_data_init_menu_items()
{
    // $CI = &get_instance();
    // $CI->app_menu->add_sidebar_menu_item('family_meta_data', [
    //     'slug'     => 'family_meta_data',
    //     'name'     => _l('family_meta_data'),
    //     'position' => 5,
    //     // 'icon'     => 'fa fa-calendar',
    //     // 'href'     => admin_url('outlook/calender')
    // ]);
}
