
<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
 
<style>
@media (min-width: 992px) {
    .custom-media {
        width: 15% !important;
        float: left;
        padding-right: 5px !important;
        padding-left: 5px !important;
    }
}
</style>
<div id="wrapper">
   <div class="content">
      
      <div class="row">

         <div class="col-md-12">
            <div class="panel_s">
               <div class="panel-body">
                 <div class="row">
                       <div class="col-md-6ths custom-media">
                          <div class="select-placeholder">
                             <select name="range" id="range" class="selectpicker" data-width="100%">
                                <option value="today" selected><?php echo _l('today'); ?></option>
                                <option value="this_month"><?php echo _l('staff_stats_this_month_total_logged_time'); ?></option>
                                <option value="last_month"><?php echo _l('staff_stats_last_month_total_logged_time'); ?></option>
                                <option value="this_week"><?php echo _l('staff_stats_this_week_total_logged_time'); ?></option>
                                <option value="last_week"><?php echo _l('staff_stats_last_week_total_logged_time'); ?></option>
                                <option value="period"><?php echo _l('period_datepicker'); ?></option>
                             </select>
                          </div>
                          <div class="row mtop15">
                             <div class="col-md-12 period hide">
                                <?php echo render_date_input('period-from'); ?>
                             </div>
                             <div class="col-md-12 period hide">
                                <?php echo render_date_input('period-to'); ?>
                             </div>
                          </div>
                       </div>
                       <div class="col-md-6ths custom-media">
                          <div class="select-placeholder">
                             <select name="staff_id" id="staff_id" class="selectpicker" multiple="1" data-width="100%" data-none-selected-text="Select Staff" data-live-search="true" tabindex="-98" data-size="5">
                               
                                <option value="<?php echo get_staff_user_id(); ?>"><?php echo get_staff_full_name(get_staff_user_id()); ?></option>
                                <?php foreach($staff_members_with_timesheets as $staff){ ?>
                                <option value="<?php echo $staff['fromuserid']; ?>"><?php echo get_staff_full_name($staff['fromuserid']); ?></option>
                                <?php } ?>
                             </select>
                          </div>
                       </div>
                       <div class="col-md-6ths custom-media">
                          <div class="select-placeholder">
                              <select data-empty-title="<?php echo _l('Status'); ?>" name="classes[]" id="classes" class="selectpicker" multiple="1" data-width="100%" data-none-selected-text="Classes" data-live-search="true" tabindex="-98" data-size="7">
                                     <?php if($classes){
                                              foreach ($classes as $class ) {
                                    ?>
                                    <option value="<?php echo $class->id;?>"><?php echo $class->name;?></option> -->            
                                    <?php     }
                                          }
                                    ?>
                              </select>
                          </div>
                       </div>
                       <div class="col-md-4ths custom-media">
                          <div class="select-placeholder">
                             <select name="follower_id" id="follower_id" class="selectpicker" multiple="1" data-width="100%" data-none-selected-text="Select Follower" data-live-search="true" tabindex="-98" data-size="5">
                               
                                <?php foreach($followers as $follower){ ?>
                                <option value="<?php echo $follower->default_follower_id; ?>"><?php echo get_staff_full_name($follower->default_follower_id); ?></option>
                                <?php } ?>
                             </select>
                          </div>
                       </div>
                    <div class="col-md-4ths custom-media">
                        <div class="select-placeholder">
                           <select name="staff_id" id="staff_id" class="selectpicker" multiple="1" data-width="100%" data-none-selected-text="Select Assignees" data-live-search="true" tabindex="-98" data-size="5">
                             
                              <?php foreach($assignees as $staff){ ?>
                              <option value="<?php echo $staff->default_assignee_id; ?>"><?php echo get_staff_full_name($staff->default_assignee_id); ?></option>
                              <?php } ?>
                           </select>
                        </div>
                    </div>
                 </div>
                 <div class="clearfix"></div>
                  <table class="table table-classStatus-report">
                     <thead>
                        <tr>
                           <th><?php echo 'Class Name'; ?></th>
                           <th><?php echo 'Action By'; ?></th>
                
                           <th><?php echo 'Date'; ?></th>
                           <th><?php echo 'Description'; ?></th>
                           
                           <th><?php echo 'Default Assignee'; ?></th>
                           <th><?php echo 'Default follower'; ?></th>
                        </tr>
                     </thead>
                     <tbody></tbody>
                     <tfoot>
                        <tr>
                           
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                        </tr>
                     </tfoot>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<?php init_tail(); ?>

<script>
   var staff_member_select = $('select[name="staff_id"]');
   $(function() {

    //init_ajax_projects_search();
    

    var timesheetsTable = $('.table-classStatus-report');
    $('#apply_filters_timesheets').on('click', function(e) {
      e.preventDefault();
      timesheetsTable.DataTable().ajax.reload();
    });

    $('body').on('change','#group_by_task',function(){
      <?php if(get_option('round_off_task_timer_option') == 0){ ?>
         var tApi = timesheetsTable.DataTable();
         var visible = $(this).prop('checked') == false;
         var tEndTimeIndex = $('.t-end-time').index();
         var tStartTimeIndex = $('.t-start-time').index();
         if(tEndTimeIndex == -1 && tStartTimeIndex == -1) {
          tStartTimeIndex = $(this).attr('data-start-time-index');
          tEndTimeIndex = $(this).attr('data-end-time-index');
        } else {
          $(this).attr('data-start-time-index',tStartTimeIndex);
          $(this).attr('data-end-time-index',tEndTimeIndex);
        }
        tApi.column(tEndTimeIndex).visible(visible, false).columns.adjust();
        tApi.column(tStartTimeIndex).visible(visible, false).columns.adjust();
        tApi.ajax.reload();
      <?php } else { ?>
        timesheetsTable.DataTable().ajax.reload();
       <?php } ?>
    });
    var Timesheets_ServerParams = {};
    Timesheets_ServerParams['range'] = '[name="range"]';
    Timesheets_ServerParams['period-from'] = '[name="period-from"]';
    Timesheets_ServerParams['period-to'] = '[name="period-to"]';
    Timesheets_ServerParams['staff_id'] = '[name="staff_id"]';

    Timesheets_ServerParams['follower_id'] = '[name="follower_id"]';

    Timesheets_ServerParams['teacher_feedback'] = 'select#teacher_feedback';
    // Timesheets_ServerParams['project_id'] = 'select#project_id';
    Timesheets_ServerParams['course_id'] = 'select#course_id';
    Timesheets_ServerParams['class_id'] = 'select#classes';
    Timesheets_ServerParams['timesheet_status'] = 'select#timesheet_status';
    Timesheets_ServerParams['clientid'] = 'select#clientid';
    Timesheets_ServerParams['group_by_task'] = '[name="group_by_task"]:checked';
    
    initDataTable('.table-classStatus-report', window.location.href, undefined, undefined, Timesheets_ServerParams, [<?php if(isset($view_all)){echo 3;} else {echo 2;} ?>, 'desc']);

    init_ajax_project_search_by_customer_id();

    $('#clientid').on('change', function(){
          var projectAjax = $('select#project_id');
          var clonedProjectsAjaxSearchSelect = projectAjax.html('').clone();
          var projectsWrapper = $('.projects-wrapper');
          projectAjax.selectpicker('destroy').remove();
          projectAjax = clonedProjectsAjaxSearchSelect;
          $('#project_ajax_search_wrapper').append(clonedProjectsAjaxSearchSelect);
          init_ajax_project_search_by_customer_id();
    });

    timesheetsTable.on('init.dt',function(){
      var $dtFilter = $('body').find('.dataTables_filter');
      var $gr = $('#group_by_tasks_wrapper').clone()
      $('#group_by_tasks_wrapper').remove();
      $gr.removeClass('hide');
      $gr.find('span').css('position','absolute');
      $gr.find('span').css('top','2px');
      $gr.find('span').css((isRTL == 'true' ? 'right' : 'left'),'-90px');
      $dtFilter.before($gr,'<div class="clearfix"></div>');
    });

    timesheetsTable.on('draw.dt', function() {
      var TimesheetsTable = $(this).DataTable();
      var logged_time = TimesheetsTable.ajax.json().logged_time;
      var chartResponse = TimesheetsTable.ajax.json().chart;
      var chartType = TimesheetsTable.ajax.json().chart_type;
      $(this).find('tfoot').addClass('bold');
      do_timesheets_title();
    });
   });
   function do_timesheets_title(){
    var _temp;
    var range = $('select[name="range"]');
    var _range_heading = range.find('option:selected').text();
    if(range.val() != 'period'){
      _temp = _range_heading;
    } else {
      _temp = _range_heading + ' ('+$('input[name="period-from"]').val() +' - '+$('input[name="period-to"]').val()+') ';
    }
    $('head title').html( _temp + (staff_member_select.find('option:selected').text() != '' ? ' - ' + staff_member_select.find('option:selected').text() : ''));
   }

   $('#clientid').change(function(){
        var client = $(this).val();
        var selectPicker = $('#classes');
        selectPicker.html('');
        $(selectPicker).selectpicker('refresh');
        if(client){
            $.ajax({
              url:admin_url + 'staff/get_family_classes',
              type:"POST",
              dataType:"json",
              data:{family:$(this).val()},
              success:function(response){
                 // console.log(response); return false;
                  var selectPicker = $('#classes');
                  selectPicker.html('');
                  $(selectPicker).selectpicker('refresh');
                  $.each(response, function(index,item){
                    selectPicker.append($('<option>',{
                        value:item.id,
                        text:item.name
                      }));
                  });
                  $(selectPicker).selectpicker('refresh');
              },
              error:function(error){
                alert(error);
              }
            });
        }
        
    })
</script>
</body>
</html>
