<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Timesheet_model extends App_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    

    /**
     * Get invoice by id
     * @param  mixed $id
     * @return array|object
     */
    public function get($id = '', $where = [])
    {
        $this->db->select('CONCAT(firstname, \' \', lastname) as staff,
            start_date,
            name as name,
            start_time,
            (SELECT GROUP_CONCAT(DISTINCT tblitems.description SEPARATOR ",") FROM tbltask_timer_details JOIN tblitems ON tbltask_timer_details.course_id = tblitems.id WHERE tbltaskstimers.id = tbltask_timer_details.timer_id LIMIT 1 ) AS courses,
            (SELECT GROUP_CONCAT(tblcoursecontents.course_title SEPARATOR ",") FROM tbltask_timer_details JOIN tblcoursecontents ON tbltask_timer_details.course_content_id = tblcoursecontents.id WHERE tbltaskstimers.id = tbltask_timer_details.timer_id ) AS course_contents,
            note,
            (end_time - start_time) as time_h,
            class_status,
            end_time,teacher_feedback');
        $this->db->from(db_prefix() . 'taskstimers');
        $this->db->join(db_prefix() . 'tasks', '' . db_prefix() . 'tasks.id = ' . db_prefix() . 'taskstimers.task_id');
        $this->db->join(db_prefix() . 'staff', '' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'taskstimers.staff_id');
        $this->db->where($where);

        $this->db->order_by('start_time', 'desc');

        return $this->db->get()->result_array();
    }
}
