<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Timetable extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('timetable_model');
        $this->load->model('staff_model');
    }
    public function index()
    {
        $data['title']                = _l('timetable');

        $data['login_user'] = get_staff();
        if (get_staff()->role == 2) {
            $data['staff'] = $this->staff_model->get('', ['active' => 1, 'staffid' => get_staff()->staffid]);
        } else {
            $data['staff'] = $this->staff_model->get('', ['active' => 1]);
        }
        $this->load->view('admin/manage', $data);
    }
    public function table()
    {
        $this->app->get_table_data(module_views_path(TIMETABLE_MODULE, 'admin/tables/timetable_table'));
    }
    public function fee_statuses()
    {
        $data['title']                = _l('fee_statuses');
        $this->db->select('DISTINCT YEAR(date) AS "year"');
        $data['years'] = $this->db->get(db_prefix().'invoices')->result_array();
        // echo "<pre>";print_r($data['years']);exit;
        $data['login_user'] = get_staff();
        $this->load->view('admin/fee_statuses', $data);
    }
    public function fee_statuses_table()
    {
        $this->app->get_table_data(module_views_path(TIMETABLE_MODULE, 'admin/tables/fee_statuses_table'));
    }
}
